//=============================================================================
// Keke_MotionBySkill - スキル毎モーション
// バージョン: 1.3.4
//=============================================================================
// Copyright (c) 2020 ケケー
// Released under the MIT license
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @target MZ
 * @plugindesc スキルごとにモーション設定する 
 * @author ケケー
 * @url https://kekeelabo.com
 * 
 * @help
 * 【ver.1.3.4】
 * スキル(アイテム)ごとにモーションと武器画像を設定できる
 * 個別設定がない場合の基本モーションも設定可能
 * 
 * 
 * ● 使い方 ●
 *
 * ■スキル(アイテム)のモーション設定
 * スキル、アイテム、武器のメモ欄に
 *
 * <モーション: (モーション名), (武器名), (前進なし)>
 *
 * ★(モーション名)
 * 以下のモーション名のいずれか
 * ※モーション名の指定がない場合は自動的に「装備」になる
 * ◎なし => モーションなし
 * ◎装備 => 装備中の武器タイプのモーション
 * ◎突き
 * ◎振り
 * ◎飛び道具
 * ◎防御
 * ◎魔法
 * ◎スキル
 * ◎アイテム
 * ◎待機
 * ◎詠唱
 * ◎回避
 * ◎勝利
 * ◎ダメージ
 * ◎異常
 * ◎倒れ
 *
 * ★(武器名)
 * 以下の武器名のいずれか(初期状態で)
 * ※武器名と画像との紐付けは下の『武器画像リスト』で変更できる
 * ※武器名の指定がない場合は自動的に「装備」になる
 * ◎なし => 武器画像なし
 * ◎装備 => 装備中の武器の武器タイプの画像
 * ◎短剣
 * ◎剣
 * ◎フレイル
 * ◎斧
 * ◎ムチ
 * ◎杖
 * ◎弓
 * ◎クロスボウ
 * ◎銃
 * ◎爪
 * ◎グローブ
 * ◎槍
 * ◎メイス
 * ◎ロッド
 * ◎棍棒
 * ◎鎖分銅
 * ◎近未来ソード
 * ◎鉄パイプ
 * ◎スリングショット
 * ◎ショットガン
 * ◎ライフル
 * ◎チェーンソー
 * ◎レールガン
 * ◎スタンロッド
 * 
 * ★(前進なし)
 * 1: 前進なし
 * 0: 前進する
 *
 * ●具体例)
 * <モーション: 突き, 剣>
 * 　モーションが「突き」、武器画像を「剣」になる
 *
 * <モーション: 装備, 装備>
 * 　モーションも武器画像も装備依存になる
 * 
 * <モーション: なし, なし>
 * 　モーションも武器画像もなし
 * 
 * <モーション: 魔法, なし, 1>
 * 　モーションは「魔法」、武技画像はなしで、前進しない
 * 
 * <モーション: , , 1>
 * 　前進しない。モーションと武技画像は基本モーション
 *
 *
 * ■モーションの優先順序
 * スキルのメモ欄設定 > 武器のメモ欄設定 > 基本モーション
 * 基本モーションはプラグインパラメータで変更できる
 * 
 * 
 * ■武器画像リスト
 * 下の方にある『武器画像』で、武器名と使う画像との紐付けを変更できる
 * 
 * 
 * ● 利用規約 ●
 * MITライセンスのもと、自由に使ってくれて大丈夫です
 *
 *
 *
 * You can set the motion and weapon image for each skill (item)
 * You can also set the basic motion when there is no individual setting
 * 
 * 
 * ● How to use ●
 *
 * ■ Skill (item) motion settings
 * In the memo field of skills, items and weapons
 *
 * <motion: (motion name), (weapon image name)>
 *
 * ★ (motion name)
 * one of the motion names below
 * ◎ None => No motion
 * ◎ Equipped => Weapon type motion of equipped weapon
 * ◎ Thrust
 * ◎ Swing
 * ◎ projectile
 * ◎ Defense
 * ◎ Magic
 * ◎ Skills
 * ◎ Item
 * ◎ Wait
 * ◎ Chant
 * ◎ Evasion
 * ◎ Victory
 * ◎ Damage
 * ◎ Abnormality
 * ◎ Collapse
 *
 * ★ (weapon image name)
 * One of the following weapon names (by default)
 * You can change the link between the weapon nameand the image
 * in the "Weapon image list" below.
 * ◎ None => No weapon image
 * ◎ Equipped => Weapon type image of equipped weapon
 * ◎ Dagger
 * ◎ Sword
 * ◎ Flail
 * ◎ Ax
 * ◎ Whip
 * ◎ Staff
 * ◎ Bow
 * ◎ Crossbow
 * ◎ Gun
 * ◎ Nails
 * ◎ Gloves
 * ◎ Spear
 * ◎ Mace
 * ◎ Rod
 * ◎ Cudgel
 * ◎ chain weight
 * ◎ near future sword
 * ◎ Iron pipe
 * ◎ Slingshot
 * ◎ Shotgun
 * ◎ Rifle
 * ◎ Chainsaw
 * ◎ Railgun
 * ◎ Stun rod
 * ※ The relationship between the weapon image name and the weapon image ID can be changed in the "Weapon image list" below.
 *
 * ★ (no advance)
 * 1: no advance
 * 0: move forward
 * 
 * ● Specific example)
 * <motion: thrust, sword>
 * 　Motion becomes "thrust", weapon image becomes "sword"
 *
 * <motion: Equip, Equip>
 * Both motion and weapon images are equipment dependent
 *
 * <motion: None, None>
 * No motion or weapon image
 *
 * <motion: Magic, None, 1>
 * "Magic" motion, no martial arts image, no forward movement
 *
 * <motion: , , 1>
 * Don't move forward. Motion and martial arts images are basic motions
 *
 *
 * ■ Motion priority order
 * Skill memo settings > Weapon memo settings > Basic motion
 * Basic motion can be changed with plugin parameters
 *
 *
 * ■ Priority order of motion
 * Skill memo settings > Weapon memo settings > Basic motion
 * Basic motion can be changed with plugin parameters
 * 
 * 
 * ● Terms of Use ●
 * Feel free to use it under the MIT license.
 * 
 * 
 * 
 * @param スキル基本モーション
 * @desc スキルの基本モーション。個別設定がない場合これが適用される
 * @default 装備, 装備
 *
 * @param 魔法基本モーション
 * @desc 魔法の基本モーション。個別設定がない場合これが適用される
 * @default 魔法, 装備
 *
 * @param アイテム基本モーション
 * @desc アイテムの基本モーション。個別設定がない場合これが適用される
 * @default アイテム, なし
 */



(() => {
    //- プラグイン名
    const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];
    
    
    
    //==================================================
    //--  武器画像リスト
    //==================================================
    
    const WeaponImageListKe = [
        "なし",    // 0
        "短剣",    // 1
        "剣",    // 2
        "フレイル",    // 3
        "斧",    // 4
        "ムチ",    // 5
        "杖",    // 6
        "弓",    // 7
        "クロスボウ",    // 8
        "銃",    // 9
        "爪",    // 10
        "グローブ",    // 11
        "槍",    // 12
        "メイス",    // 13
        "ロッド",    // 14
        "棍棒",    // 15
        "鎖分銅",    // 16
        "近未来ソード",    // 17
        "鉄パイプ",    // 18
        "スリングショット",    // 19
        "ショットガン",    // 20
        "ライフル",    // 21
        "チェーンソー",    // 22
        "レールガン",    // 23
        "スタンロッド"    // 24
    ];
    
    
    
    //==================================================
    //--  パラメータ受け取り
    //==================================================
    
    const parameters = PluginManager.parameters(pluginName);
    
    const keke_skillBasicMotion = parameters["スキル基本モーション"];
    const keke_spellBasicMotion = parameters["魔法基本モーション"];
    const keke_itemBasicMotion = parameters["アイテム基本モーション"];
    
    
    
    //==================================================
    //--  スキル毎モーション
    //==================================================
    
    //- スキルモーションのセット呼び出し(コア追加)
    const _Game_Actor_performAction = Game_Actor.prototype.performAction;
    Game_Actor.prototype.performAction = function(action) {
        _Game_Actor_performAction.apply(this, arguments);
        // スキルモーションのセット
        setSkillMotion(this, action);
    };
    
    
    //- スキルモーションのセット
    function setSkillMotion(battler, action) {
        if (!action.isSkill() && !action.isItem()) { return; }
        let dataList = [];
        // アクションのメモ欄からモーションデータ取得
        const item = action.item();
        const actionData = item.meta["モーション"] || item.meta["motion"] || "";
        dataList.push(actionData.replace(/\s/g, "").split(","));
        // 武器のメモ欄からモーションデータ取得
        const weapons = battler.weapons();
        if (weapons && Array.isArray(weapons)) {
            for (let weapon of weapons) {
                const d = weapon.meta["モーション"] || weapon.meta["motion"];
                if (d) {
                    dataList.push(d.replace(/\s/g, "").split(","));
                }
            };
        }
        // 基本モーションデータを取得
        let baseData = "";
        if (action.isSkill()) {
            baseData = action.isMagicSkill() ? keke_spellBasicMotion : keke_skillBasicMotion;
        } else {
            baseData = keke_itemBasicMotion;
        }
        dataList.push(baseData.replace(/\s/g, "").split(","));
        // モーションデータを統合
        let datas = [];
        for (let i = 0; i < 3; i++) {
            for (const ds of dataList) {
                if (ds[i]) {
                    datas[i] = ds[i];
                    break;
                }   
            }
        }
        // 装備タイプを取得
        const wTypeId = weapons[0] ? weapons[0].wtypeId : 0;
        const wType = $dataSystem.weaponTypes[wTypeId];
        // モーション名を取得
        let motion = datas[0];
        // モーション名がないか「装備」なら装備中の武器のモーションを適用
        if (!motion || motion == "装備") {
            const aMotion = $dataSystem.attackMotions[wTypeId];
            motion = aMotion.type == 0 ? "thrust" : aMotion.type == 1 ? "swing" : "missile";
        }
        // モーションセット
        if (motion == "なし" || motion == "none") {
            battler.requestMotion("walk");
        } else if (motion == "突き" || motion == "thrust") {
            battler.requestMotion("thrust");
        } else if (motion == "振り" || motion == "swing") {
            battler.requestMotion("swing");
        } else if (motion == "飛び道具" || motion == "missile") {
            battler.requestMotion("missile");
        } else if (motion == "防御" || motion == "guard") {
            battler.requestMotion("guard");
        } else if (motion == "魔法" || motion == "spell") {
            battler.requestMotion("spell");
        } else if (motion == "スキル" || motion == "spell") {
            battler.requestMotion("skill");
        } else if (motion == "アイテム" || motion == "item") {
            battler.requestMotion("item");
        } else if (motion == "待機" || motion == "wait") {
            battler.requestMotion("wait");
        } else if (motion == "詠唱" || motion == "chant") {
            battler.requestMotion("chant");
        } else if (motion == "回避" || motion == "evade") {
            battler.requestMotion("evade");
        } else if (motion == "勝利" || motion == "victory") {
            battler.requestMotion("victory");
        } else if (motion == "ダメージ" || motion == "damage") {
            battler.requestMotion("damage");
        } else if (motion == "異常" || motion == "abnormal") {
            battler.requestMotion("abnormal");
        } else if (motion == "倒れ" || motion == "dead") {
            battler.requestMotion("dead");
        }
        // 武器名を取得
        let weapon = datas[1];
        // 名前がないか「装備」なら装備中の武器を適用
        if (!weapon || weapon == "装備") { weapon = wType; }
        // 武器画像をセット
        if (weapon) {
            // なし の場合は武器画像なし
            if (weapon == "なし" && weapon == "none") {
                battler.startWeaponAnimation(0);
            } else {
                const wpImgId = WeaponImageListKe.indexOf(weapon);
                if (wpImgId >= 0) { battler.startWeaponAnimation(wpImgId); }
            }
        }
        // 前進なしフラグ
        if (Number(datas[2])) {
            battler._noStepForwardKe = true;
        }
    };


    //- 前進なしフラグの適用(コア追加)
    const _Sprite_Actor_shouldStepForward = Sprite_Actor.prototype.shouldStepForward;
    Sprite_Actor.prototype.shouldStepForward = function() {
        if (this._battler._noStepForwardKe) { 
            return false;
        }
        return _Sprite_Actor_shouldStepForward.apply(this);
    };


    //- アクション準備時に前進なしフラグを解除(コア追加)
    const _Game_Action_prepare = Game_Action.prototype.prepare;
    Game_Action.prototype.prepare = function() {
        _Game_Action_prepare.apply(this);
        this.subject()._noStepForwardKe = null;
    };
    
})();